	function h = FLAT_LP_FIR_1(N, L, wsT)
	
	% A program for the design of symmetric lowpass FIR 
	% filters with flat monotonically decreasing passbands and 
	% equiripple stopbands.
	
	% output
	%  h  : filter
	% input
	%  N  :  filter order (even)
	%  L  : degree of flatness at wT = 0
	%  wsT : stopband edge (0-pi)
	
	%
	%  Modifiesd	LW 2002-02-04
	
	% Reference:
	% "Exchange Algorithms for the Design of Linear Phase FIR Filters 
	% and Differentiators Having Flat Monotonic Passbands and Equiripple 
	% Stopbands" by I. W. Selesnick and C. S. Burrus, 
	% IEEE Trans. on Cicuits and Systems, Part II, 43(9):671-675, Sept 1996
	
	%  calls subprograms: REFINE.m and LOCAL_MAX.m
	
	N = N+1; % filter length
	if (rem(N,2) == 0) | (rem(L,2) == 1)
		disp('N and L must be be even')
		return
	else
		g = 2^ceil(log2(10*N));               	% number of grid points
		SN = 1e-10;                             % SN : SMALL NUMBER
		q  = (N-L+1)/2;                         % number of filter parameters
		w = [0:g]'*pi/g;
		rs = [0:q]'*(pi-wsT)/(q) + wsT;
		Z = zeros(2*(g+1-q)-1,1);
		A1 = (-1)^(L/2) * (sin(w/2)).^L;
		si = (-1).^[0:q]';
		n = 0:q-1;
		A1r = (-1)^(L/2) * (sin(rs/2)).^L;
		it = 0;
		while 1 & (it < 10)
			x = [cos(rs*n), si./A1r]\[1./A1r];
			a = -x(1:q);
			del = x(q+1);
			A2 = real(fft([a(1);a(2:q)/2;Z;a(q:-1:2)/2])); A2 = A2(1:g+1);
			A = 1 + A1.*A2;
			Y = si*del;
			ri = sort([LOCAL_MAX(A); LOCAL_MAX(-A)]);
			ri(1:length(ri)-q) = [];
			rs = (ri-1)*pi/g;
			rs = REFINE(a,L/2,rs);
			rs = [wsT; rs];
			A1r = (-1)^(L/2) * (sin(rs/2)).^L;
			Ar = 1 + (cos(rs*n)*a).*A1r;
			Err = max([max(Ar)-del, -del-min(Ar)]);
			%	fprintf(1,'    Err = %18.15f\n',Err);
			%	if Err < SN, fprintf(1,'\n   Converged \n'), break, end
			it = it + 1;
		end
		h = [a(q:-1:2)/2; a(1); a(2:q)/2]; % H2
		for k = 1:L/2
			h = conv(h,[1 -2 1]')/4;	% Add H1
		end
		h((N+1)/2) = h((N+1)/2) + 1;
	end

